<?php 
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */
    
    include "../include/includeBaseComponenti.php";
    include "../../../template/stile.php";
    include "../../../classi/Contenuto.php";
    include "classi/ElementoPortfolio.php";
    
    if(isset($_GET["id"])) {
        $contenuto = new ElementoPortfolio($geecomDb, filter_input(INPUT_GET,"id",FILTER_SANITIZE_NUMBER_INT));
        $contenuto->caricaDatiDalDatabase();
        $datiOccorrenza = $geecomDb->leggiSingolaRiga("geec_portfolio",$contenuto->getContenutoRiferimento());
        $tipoElemento   = "elementoPortfolio";
    }
?>
<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
        <?php
            include "../include/cssBaseComponenti.php";
        ?>
        <title>Geecom CMS - Creazione elemento portfolio</title>
    </head>
    <body>
    
        <header>
            <?php 
                include "../../include/barraSuperiore.php";

                include "../../include/header.php";

                include "../../include/barraMenu.php";
            ?>
        </header>
	
        <main role="main" class="bg-light" id="main">
            <div class="container-fluid">

                <?php 
                    if(isset($_GET["status"])) {
                        $status = filter_input(INPUT_GET,"status",FILTER_SANITIZE_NUMBER_INT);
                    }
                    else {
                        $status = 0;
                    }

                ?>
                <form name="formElementoPortfolio" action="controller/controllerElementi.php" method="post">
                    <input type="text" class="d-none" name="operazione" value="modifica">
                    <input type="text" class="d-none" name="id" value="<?php echo((isset($contenuto) ? $contenuto->getId() : "0")); ?>">
                    
                    <div class="row py-4">
                        <?php 
                            if($status==300) {
                                echo"<div class=\"col-12\">
                                        <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                            Elemento modificato
                                            <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                                  <span aria-hidden=\"true\">&times;</span>
                                            </button>
                                        </div>
                                    </div>";
                            }
                            else if($status==310) {
                                 echo"<div class=\"col-12\">
                                        <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                            Elemento duplicato, modificalo per non avere due contenuti uguali
                                            <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                                  <span aria-hidden=\"true\">&times;</span>
                                            </button>
                                        </div>
                                    </div>";
                            }
                            else if($status==320) {
                                 echo"<div class=\"col-12\">
                                        <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                            Traduzione creata, inserisci i testi nella lingua da te scelta
                                            <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                                  <span aria-hidden=\"true\">&times;</span>
                                            </button>
                                        </div>
                                    </div>";
                            }
                            else if($status==350) {
                                 echo"<div class=\"col-12\">
                                        <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                            Impostazioni sezione componente aggiornate
                                            <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                                  <span aria-hidden=\"true\">&times;</span>
                                            </button>
                                        </div>
                                    </div>";
                            }
                            else if($status==360) {
                                 echo"<div class=\"col-12\">
                                        <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                            Elemento spostato nel nuovo portfolio
                                            <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                                  <span aria-hidden=\"true\">&times;</span>
                                            </button>
                                        </div>
                                    </div>";
                            }
                            else if($status==370) {
                                 echo"<div class=\"col-12\">
                                        <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                            Elemento duplicato nel nuovo portfolio
                                            <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                                  <span aria-hidden=\"true\">&times;</span>
                                            </button>
                                        </div>
                                    </div>";
                            }
                        ?>
                        <input type="text" class="d-none" id="operazione" value="modifica">

                        <div class="col-lg-8">
                            <form name="formComponente" action="controller/controllerComponente.php" method="post">
                                <input type="text" class="d-none" name="operazione" value="<?php echo((isset($contenuto) ? "modifica" : "crea")); ?>">
                                <input type="text" class="d-none" name="id" value="<?php echo((isset($contenuto) ? $contenuto->getId() : "0")); ?>">
                                
                                <div class="form-row justify-content-between mb-3">
                                    <div class="col-auto d-flex">
                                        <nav aria-label="breadcrumb" class="align-self-center">
                                            <ol class="breadcrumb p-0 mb-1 mb-md-0 bg-transparent">
                                                <li class="breadcrumb-item"><a href="../../home.php">Home</a></li>
                                                <li class="breadcrumb-item"><a href="#" data-toggle="modal" data-target="#menu-componenti">Componenti</a></li>
                                                <li class="breadcrumb-item"><a href="index.php">Portfolio</a></li>
                                                <li class="breadcrumb-item"><a href="creaPortfolio.php?id=<?php echo $datiOccorrenza["id"] ?>"><?php echo $datiOccorrenza["nome"] ?></a></li>
                                                <li class="breadcrumb-item active" aria-current="page"><?php echo((isset($contenuto)? $contenuto->getTitolo() : "Nuovo elemento"))?></li>
                                            </ol>
                                        </nav>
                                    </div>
                                    <div class="col-auto text-right">
                                        <a class="btn btn-outline-primary" href="creaPortfolio.php?id=<?php echo $datiOccorrenza["id"] ?>"><i class="fas fa-arrow-left mr-2"></i>Torna all'elenco</a>
                                    </div>
                                </div>
                                
                                <div class="card mb-4 box-shadow-lite">
                                    <div class="card-header py-3">
                                        <div class="row">
                                            <div class="form-group col-10 flex-lg-shrink-1 d-md-flex align-items-center">
                                                <label class="mr-3 mb-0">Titolo:</label>
                                                <input type="text" class="form-control" id="nomeSlider" name="titolo" aria-describedby="titolo elemento" value="<?php echo((isset($contenuto) ? $contenuto->getTitolo() : "")) ?>" placeholder="Elemento portfolio">
                                            </div>
                                            
                                            <div class="form-group col-md-2 text-right">
                                                <label for="stato" class="mr-3 mb-0">Pubblicato</label>
                                                <input type="checkbox" id="stato" name="stato" class="js-switch" value="pubblicato" <?php echo(($contenuto->getId()!=0 && $contenuto->getStato()=="pubblicato") ? "checked" :"") ?> >
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div id="divAliasContenuto" class="form-group <?php echo(($contenuto->getCommenti()=="si") ? "col-12" : "col-md-5") ?>">
                                                <label for="titolo-articolo" id="labelAlias"><?php echo(($contenuto->getCommenti()=="si") ? "URL" : "Alias") ?></label>
                                                <input  type="text" class="form-control" id="valoreAlias" name="alias" value="<?php echo((isset($contenuto)? $contenuto->getAlias() : ""))?>" placeholder="Link">
                                            </div>

                                            <div id="divUrlContenuto" class="<?php echo(($contenuto->getCommenti()=="no") ? "form-group col-md-7" : "d-none") ?>">
                                                <label for="url-seo">URL</label>
                                                <input type="text" class="form-control" id="url-seo" name="alias" value="<?php echo((isset($contenuto)? GeneratoreUrl::creaUrlContenuto($contenuto->getDatiContenuto(), $impostazioni["ottimizzazioneUrl"], $impostazioni["urlSito"]) : ""))?>" disabled>
                                                <small class="text-muted"> l'URL a cui è raggiungibile il contenuto </small>
                                            </div>

                                            <div class="form-group col-md-5">
                                                <label for="sottotitolo-articolo">Meta titolo</label>
                                                <textarea class="form-control" id="metaTitolo" name="metaTitolo" rows="2"><?php echo((isset($contenuto)? $contenuto->getMetaTitolo() : ""))?></textarea>
                                                <small class="text-muted">Il meta titolo viene inserito nel meta tag title. Può essere uguale al titolo visto dagli utenti oppure diverso</small>
                                            </div>
                                            
                                            <div class="form-group col-md-7">
                                                <label for="sottotitolo-articolo">Meta descrizione</label>
                                                <textarea class="form-control" id="descrizione" name="metaDescrizione" rows="2"><?php echo((isset($contenuto)? $contenuto->getMetaDescrizione() : ""))?></textarea>
                                                <small class="text-muted"> Inserisci una breve descrizione di questo contenuto, verrà mostrata nei risultati di ricerca di Google </small>
                                            </div>

                                            <div class="form-group col-6">
                                                <label for="select1" class="sottotitolo-articolo">Categoria</label>
                                                <select class="selectpicker w-100" name="categoria">
                                                    <option value="0">Nessuna</option>
                                                    <?php
                                                        $queryNomiTag = "SELECT * FROM geec_categorie WHERE tipo LIKE 'categoriaPortfolio' AND categoriaMadre = {$contenuto->getContenutoRiferimento()}";
                                                        $risNomi = $geecomDb->eseguiQueryLettura($queryNomiTag);
                                                        while($categoria = $risNomi->fetch_assoc()) {
                                                            if(isset($contenuto) && $contenuto->getCategoria() == $categoria["id"]) {
                                                                $selezionato  = "selected";
                                                            }
                                                            else {
                                                                $selezionato  = "";
                                                            }
                                                            echo"<option value=\"{$categoria["id"]}\" $selezionato >{$categoria["nome"]}</option>";
                                                        }
                                                    ?>
                                                </select>
                                            </div>

                                            <div class="form-group col-6">
                                                <label class="d-block">Usa link personalizzato</label>
                                                <input type="checkbox" id="linkPersonalizzato" name="abilitaCommenti" class="js-switch" value="si" <?php echo(($contenuto->getCommenti()=="si") ? "checked" : "") ?> onchange="gestoreLinkPersonalizzato()">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="card-body wrapper-sezioni-pagina">
                                        <div class="my-4">
                                            <textarea class="tiny" name="testo"><?php echo(isset($contenuto) ? $contenuto->getTesto() : "") ?></textarea>
                                        </div>

                                        <button type="button" class="btn btn-primary float-right mt-3" onclick="document.formElementoPortfolio.submit()"><i class="fas fa-check"></i> Salva</button>
                                    </div>
                                </form>
                            </div>
                            
                
                            <div class="card mb-4 box-shadow-lite">
                                <div class="card-header">
                                    <div class="card-title mb-0">Immagini associate</div>
                                </div>
                                <div class="card-body">
                                    
                                    <form action="../../../controller/controllerContenuti.php" id="frmFileUpload-00" class="dropzone singolo-file mb-3" method="post" enctype="multipart/form-data">
                                        <div class="dz-message">
                                            <i class="fas fa-file-upload fa-2x mb-2"></i>
                                            <h5>Trascina o carica qui le immagini</h5>
                                        </div>
                                        <div class="fallback">
                                            <input name="file" type="file" />
                                        </div>
                                    </form>

                                    <div id="divElencoImmagini" class="gerarchia-menu">
                                        <?php 
                                            $contenuto->stampaImmaginiElemento();
                                        ?>
                                    </div>
                                </div>
                            </div>
                                
                            <div class="card mb-4 box-shadow-lite accordion">
                                <div class="card-header" data-toggle="collapse" area-expanded="true" href="#componentiAggiuntivi">
                                    <a class="card-title">Componenti associati</a>
                                </div>
                                <div id="componentiAggiuntivi" class="collapse show">
                                    <div class="card-body wrapper-sezioni-pagina">
                                        <div id="componentiContenuto">
                                            <?php 
                                                $contenuto->stampaComponentiContenuto($percorsoBase);
                                            ?>
                                        </div>
                                        <button type="button" class="btn btn-success btn-block" data-toggle="modal" data-target="#aggiungi-componente-articolo"><i class="fas fa-plus"></i> Aggiungi un componente</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Colonna principale -->

                        <!--Colonna secondaria -->
                        <div class="col-lg-4  align-self-start sticky-top">
                            <div class="btn-group d-flex mb-3" role="group" aria-label="Basic example">
                                <button type="button" class="btn btn-primary w-100" onclick="document.formElementoPortfolio.submit()"><i class="fas fa-check mr-2"></i>Salva</button>
                                <?php 
                                    if(isset($contenuto)) {
                                ?>
                                        <button type="button" class="btn btn-warning w-100" onclick="location.href='controller/controllerComponente.php?id=<?php echo $datiOccorrenza["id"] ?>&idElemento=<?php echo $contenuto->getId() ?>&operazione=duplicaElementoPortfolio';"><i class="far fa-clone mr-2"></i>Duplica</button>
                                        <a class="btn btn-secondary w-100" href="<?php echo GeneratoreUrl::creaUrlContenuto($contenuto->getDatiContenuto(), $impostazioni["ottimizzazioneUrl"], $impostazioni["urlSito"]) ?>"><i class="fas fa-external-link-square-alt mr-2"></i>Visualizza</a>
                                <?php
                                    }
                                ?>
                            </div>

                            <div class="card mb-3 rounded-0 accordion box-shadow-lite">
                                <div class="card-header collapsed" data-toggle="collapse" href="#ImmagineInEvidenza">
                                    <a class="card-title">
                                        Immagine in evidenza
                                    </a>
                                </div>
                                <div id="ImmagineInEvidenza" class="collapse show">
                                    <div class="card-body">
                                        <div class="img-container">
                                            <div class="azioni">
                                                <div class="btn-group" role="group" aria-label="">
                                                    <button onclick="eliminaImmagineInEvidenza()" type="button" class="btn btn-sm btn-light elimina" data-toggle="tooltip" data-placement="bottom" title="Rimuovi"><i class="far fa-trash-alt"></i></button>
                                                </div>
                                            </div>
                                            
                                            <img id="immagineInEvidenza" class="img-fluid w-100 mb-3" src="../../../<?php echo((isset($contenuto) && $contenuto->getFoto()!="") ? $contenuto->getFoto() : "immagini/altro/segnaposto.png") ?>" alt="immagine attuale">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="card mb-3 rounded-0 accordion box-shadow-lite">
                                <div class="card-header collapsed" data-toggle="collapse" href="#template">
                                    <a class="card-title">
                                        Template
                                    </a>
                                </div>
                                <div id="template" class="collapse show">
                                    <div class="card-body">
                                        <div class="form-group mb-0">
                                            <select class="form-control" name="template">
                                                <?php
                                                    foreach($templateElementiPortfolio as $key=>$value) {
                                                        if(isset($contenuto) && $contenuto->getTemplate()==$value) {
                                                            echo"<option value=\"$value\" selected>$key </option>";						
                                                        }
                                                        else {
                                                            echo"<option value=\"$value\" >$key </option>";
                                                        }
                                                    }
                                                ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <?php 
                                if(isset($contenuto)) {
                                    $query = "SELECT * FROM geec_portfolio WHERE id != {$contenuto->getContenutoRiferimento()}";
                                }
                                else {
                                    $query = "SELECT * FROM geec_portfolio";
                                }
                                $risPortfolii = $geecomDb->eseguiQueryLettura($query);
                                
                                if($risPortfolii->num_rows>0) {
                            ?>
                            <div class="card mb-3 rounded-0 accordion box-shadow-lite">
                                <div class="card-header collapsed" data-toggle="collapse" href="#spostaDuplica">
                                    <a class="card-title">
                                        Sposta / duplica in altro portfolio
                                    </a>
                                </div>
                                <div id="spostaDuplica" class="collapse show">
                                    <div class="card-body">
                                        <div class="form-group">
                                            <select class="form-control" id="portfolioDestinazione">
                                                <?php
                                                    while($portfolio = $risPortfolii->fetch_assoc()) {
                                                        echo"<option value=\"{$portfolio["id"]}\" >{$portfolio["nome"]} </option>";
                                                    }
                                                ?>
                                            </select>
                                        </div>
                                        <button type="button" class="btn btn-primary btn-block mb-2" onclick="{spostaElemento(<?php echo $contenuto->getId() ?>)}"><i class="fa fa-arrow-right"></i> Sposta nel portfolio selezionato</button>
                                        <button type="button" class="btn btn-outline-primary btn-block" onclick="{duplicaElemento(<?php echo $contenuto->getId() ?>)}"><i class="fa fa-copy"></i> Copia nel portfolio selezionato</button>
                                    </div>
                                </div>
                            </div>
                            <?php
                                }
                            ?>
                        </div>
                </div>

            </div>
        </main>

        <?php 
            include "../../include/footer.php";

            include "../include/modal/cambiaPassword.php";

            include "../../include/modalAggiungiComponenteArticolo.php";
            
            include "../../include/modal/modalMenuComponenti.php";

            include "../../include/modal/operazioneCompletata.php";
            
        ?>
        
            <div class="modal fade" id="modifica-impostazioni-sezione" tabindex="-1" role="dialog" aria-labelledby="modifica impostazioni sezione" aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Opzioni sezione</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <form name="formImpostazioniSezione" action="../../../controller/controllerContenuti.php" method="post" enctype="multipart/form-data">
                                <input type="text" class="d-none" name="id" value="<?php echo((isset($contenuto)) ? $contenuto->getId() : "0") ?>">
                                <input type="text" class="d-none" id="idSezioneDaModificare" name="idSezioneDaModificare">
                                <input type="text" class="d-none" name="operazione" value="modificaOpzioniSezione">
                                <div class="form-group row">
                                      <label for="idSezione" class="col-sm-2 col-form-label">ID</label>
                                      <div class="col-sm-10">
                                        <input type="text" class="form-control" id="idSezione" name="idSezione" placeholder="ID">
                                        <small class="form-text text-muted"> L'ID deve essere unico </small>
                                      </div>
                                </div>
                                <div class="form-group row">
                                      <label for="classeSezione" class="col-sm-2 col-form-label">Classi</label>
                                      <div class="col-sm-10">
                                        <input type="text" class="form-control" id="classeSezione" name="classeSezione" placeholder="classi">
                                        <small class="form-text text-muted"> Inserisci le classi aggiuntive separate da uno spazio, ad es.: "mt-0 bg-dark text-negative"</small>
                                      </div>
                                </div>
                                <hr>
                                <div class="form-group" id="contenitoreCheckboxLarghezza">
                                    <input type="checkbox" id="sezioneATuttaLarghezza" name="sezioneATuttaLarghezza" value="si" />
                                    <label>A tutta larghezza</label>
                                </div>
                                <hr>
                                <div class="form-row">
                                    <div class="form-group col-sm-6">
                                        <label>Margine</label>
                                        <input type="text" class="form-control" id="margineSezione" name="margineSezione" value="">
                                        <small class="form-text text-muted"> Personalizza il margine della sezione, ad es.: "1em 1em 1em 1em"</small>
                                    </div>
                                    <div class="form-group col-sm-6">
                                        <label>Padding</label>
                                        <input type="text" class="form-control" id="paddingSezione" name="paddingSezione" placeholder="">
                                        <small class="form-text text-muted"> Personalizza il padding della sezione, ad es.: "1em 1em 1em 1em"</small>
                                    </div>
                                </div>

                                <hr class="mt-0">
                                <h6> Colore di sfondo </h6>
                                <div class="form-row">
                                    <div class="form-group col-sm-6">
                                        <div id="divContenitoreColorPicker" class="">

                                        </div>
                                        <small class="form-text text-muted">Se non impostato la sezione avrà uno sfondo trasparente</small>
                                    </div>
                                    <div class="form-group col-sm-6">
                                        <select class="form-control" id="colore-predefinito-valore" onchange="aggiornaColoreSezione()">
                                            <option value="">Seleziona tra i colori predefiniti</option>
                                            <option value="<?php echo $configurazioneAspetto["colorePrimario"] ?>">Primary</option>
                                            <option value="<?php echo $configurazioneAspetto["coloreSecondario"] ?>">Secondary</option>
                                            <option value="<?php echo $configurazioneAspetto["coloreSuccess"] ?>">Success</option>
                                            <option value="<?php echo $configurazioneAspetto["coloreDanger"] ?>">Danger</option>
                                            <option value="<?php echo $configurazioneAspetto["coloreWarning"] ?>">Warning</option>
                                            <option value="<?php echo $configurazioneAspetto["coloreInfo"] ?>">Info</option>
                                            <option value="<?php echo $configurazioneAspetto["coloreDark"] ?>">Dark</option>
                                            <option value="<?php echo $configurazioneAspetto["coloreLight"] ?>">Light</option>
                                        </select>
                                    </div>
                                </div>

                                <hr class="mt-0">
                                <div class="form-row">
                                    <div class="form-group col-sm-9">
                                        <h6> Immagine di sfondo </h6>
                                        <input name="file" type="file" accept="image/*"/>
                                        <small class="d-block text-muted form-text">Se presente, l'immagine di sfondo verrà visualizzata al posto del video sui dispositivi che non ne consentono la riproduzione.</small>
                                    </div>
                                    <div class="form-group col-sm-3">
                                        <div class="img-container">
                                            <div class="azioni">
                                                <div class="btn-group" role="group" aria-label="">
                                                    <button onclick="eliminaImmagineSezione()" type="button" class="btn btn-sm btn-light elimina" data-toggle="tooltip" data-placement="bottom" title="" data-original-title="Rimuovi"><i class="far fa-trash-alt"></i></button>
                                                </div>
                                            </div>
                                            <img id="immagineDiSfondoSezione" class="img-fluid"  alt="immagine sezione">
                                        </div>
                                    </div>
                                </div>

                                <hr class="mt-0">
                                <div class="form-row">
                                    <div class="form-group col-sm-9">
                                        <h6> Video di sfondo </h6>
                                        <input name="video" type="file" accept="video/*" />
                                    </div>
                                    <div class="form-group col-sm-3">
                                        <div class="video-container">
                                            <div class="azioni">
                                                <div class="btn-group" role="group" aria-label="">
                                                    <button onclick="eliminaVideoSezione()" type="button" class="btn btn-sm btn-light elimina" data-toggle="tooltip" data-placement="bottom" title="" data-original-title="Rimuovi"><i class="far fa-trash-alt"></i></button>
                                                </div>
                                            </div>
                                            <video id="videoDiSfondoSezione" class="embed-responsive embed-responsive-16by9" poster="../immagini/altro/segnaposto.png" >
                                                <source id="sorgenteVideoDiSfondo" src="" type="video/mp4">
                                            </video>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="modal-footer">
                              <button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                              <button type="button" class="btn btn-primary btn-sm" onclick="document.formImpostazioniSezione.submit()"><i class="fas fa-check"></i> Salva</button>
                        </div>
                      </div>
                </div>
            </div>
        
            <div class="modal fade" id="modalEliminaComponente" tabindex="-1" role="dialog" aria-labelledby="modifica componente intestazione" aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Eliminare il componente?</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                            <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <div class="d-flex flex-row justify-content-center">
                                <img id="immagineComponenteDaEliminare" class="thumb d-none d-lg-block" src="">
                                <div class="align-self-center">
                                    <span class="mr-3 align-self-center text-primary"><em id="nomeComponenteDaEliminare"></em></span>
                                    <div id="nomeElementoDaEliminare"></div>
                                </div>
                            </div>
                            <input type="text" class="d-none" id="componenteDaEliminare">
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-outline-primary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                            <button type="button" class="btn btn-primary btn-sm" onclick="eseguiEliminazioneComponentePagina()"><i class="fas fa-check"></i> Elimina</button>
                        </div>
                    </div>
                </div>
            </div>

            <div class="modal fade" id="modalEliminaImmagine" tabindex="-1" role="dialog" aria-labelledby="modifica componente intestazione" aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Eliminare l'immagine?</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                            <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <div class="d-flex flex-row justify-content-center">
                                <img id="percorsoImmagineDaEliminare" class="img-fluid" src="">
                            </div>
                            <input type="text" class="d-none" id="idImmagineDaEliminare">
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-outline-primary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                            <button type="button" class="btn btn-primary btn-sm" onclick="eseguiEliminazioneOccorrenzaImmagine('../../../')"><i class="fas fa-check"></i> Elimina</button>
                        </div>
                    </div>
                </div>
            </div>
        <?php
            
            include "../../include/modalModificheComponenti.php";
        
            include "../include/jsBaseComponenti.php";
        ?>
        
        <!-- Dropzone -->
        <script type="text/javascript" src="../../../plugins/dropzone/dropzone.js"></script>
        <script>
            $("#frmFileUpload-00").dropzone({
                acceptedFiles: ".jpeg,.jpg,.png,.webp,.gif,.svg",
                maxFiles: 10,
                parallelUploads: 10,
                addRemoveLinks: true,
                dictRemoveFile: "Rimuovi",
                success: function(file,response) {
                    this.removeAllFiles();
                    aggiornaDivImmagini();
                },
                params:{
                    operazione:"aggiungiImmaginiElementoPortfolio",
                    idElemento:<?php echo $contenuto->getId() ?>,
                    id:<?php echo $contenuto->getContenutoRiferimento() ?>
                },
                maxfilesexceeded: function(file) {
                    this.removeAllFiles();
                    this.addFile(file);
                }
            })
            
            function aggiornaDivImmagini() {
                $.ajax({
                    type:"POST",
                    url:"controller/controllerElementi.php",
                    data:{
                        operazione:"stampaElencoImmagini",
                        id:<?php echo $contenuto->getId() ?>
                    },
                    success:function(codice) {
                        document.getElementById("divElencoImmagini").innerHTML = codice;
                    },
                    error: function(xhr,status,error) {
                        alert(status+" "+error);
                    }
                });
            }
        </script>

        <script>
            function modificaImpostazioniSezione(id,idSezione,classeSezione,aTuttaLarghezza,margineSezione,paddindSezione,coloreSfondo,immagineDiSfondo,videoDiSfondo) {
                document.getElementById("idSezioneDaModificare").value = id;
                document.getElementById("idSezione").value      = idSezione;
                document.getElementById("classeSezione").value  = classeSezione;
                document.getElementById("margineSezione").value = margineSezione;
                document.getElementById("paddingSezione").value = paddindSezione;
                
                if (typeof switchModalSezione !== 'undefined') {
                    switchModalSezione.destroy();
                    document.getElementById("contenitoreCheckboxLarghezza").innerHTML = "";
                    
                    document.getElementById("contenitoreCheckboxLarghezza").innerHTML = "<input type=\"checkbox\" id=\"sezioneATuttaLarghezza\" name=\"sezioneATuttaLarghezza\" value=\"si\" /><label>A tutta larghezza</label>";                    
                }
                
                var checkboxSezioneATuttaLarghezza = document.getElementById("sezioneATuttaLarghezza");
                if(aTuttaLarghezza==='si') {    
                    checkboxSezioneATuttaLarghezza.checked   = true;
                }
                checkboxSezioneATuttaLarghezza.className = "js-switch-modal";
                
                var elementoSwitchModal = document.querySelector('.js-switch-modal');
                switchModalSezione  = new Switchery(elementoSwitchModal,{ size: 'small', color: 'var(--primary)', jackColor: '#FFF' });
                
                // creo il colorpicker
                if (typeof colorPickerSezione !== 'undefined') {
                    $('.selettore-colore').colorpicker('destroy');
                    
                    document.getElementById("divContenitoreColorPicker").innerHTML = "<input type=\"text\" id=\"coloreSfondo\" name=\"coloreSfondo\" class=\"form-control\" /><span class=\"input-group-append\"><span class=\"input-group-addon input-group-text\"><i></i></span></span>";
                    document.getElementById("divContenitoreColorPicker").className = "input-group colorpicker-component selettore-colore";
                    document.getElementById("coloreSfondo").value   = coloreSfondo;

                    colorPickerSezione = $('.selettore-colore').colorpicker({
                        format: 'hex'
                    });
                }
                else {
                
                    document.getElementById("divContenitoreColorPicker").innerHTML = "<input type=\"text\" id=\"coloreSfondo\" name=\"coloreSfondo\" class=\"form-control\" /><span class=\"input-group-append\"><span class=\"input-group-addon input-group-text\"><i></i></span></span>";
                    document.getElementById("divContenitoreColorPicker").className = "input-group colorpicker-component selettore-colore";
                    document.getElementById("coloreSfondo").value   = coloreSfondo;

                    colorPickerSezione = $('.selettore-colore').colorpicker({
                        format: 'hex'
                    });
                }
                
                if(immagineDiSfondo=="") {
                    document.getElementById("immagineDiSfondoSezione").src = "../../../immagini/altro/segnaposto.png";
                }
                else {
                    document.getElementById("immagineDiSfondoSezione").src = "../../../"+immagineDiSfondo;
                }
                
                var video = document.getElementById("videoDiSfondoSezione");
                if(videoDiSfondo=="") {
                    video.setAttribute('poster','../immagini/altro/segnaposto.png');
                    if (video.hasAttribute("controls")) {
                        video.removeAttribute("controls")   
                    }
                }
                else {
                    video.removeAttribute('poster');
                    if (!video.hasAttribute("controls")) {
                        video.setAttribute("controls","controls")   
                    }
                    document.getElementById("sorgenteVideoDiSfondo").src = "../"+videoDiSfondo;
                    video.load();
                }
                
                $('#modifica-impostazioni-sezione').modal('show');
            }
            
            function modificaPosizioneComponenteDaInput(idComponente) {
                var posizione = document.getElementById("posizioneComponente"+idComponente).value;
                modificaPosizioneComponente(idComponente,posizione);
            }

            function modificaPosizioneComponente(idComponente,posizione) {
                $.ajax({
                    type:"POST",
                    url:"../../../controller/controllerContenuti.php",
                    data:{
                        operazione:"modificaPosizioneComponente",
                        id:<?php echo $contenuto->getId() ?>,
                        idComponente:idComponente,
                        posizione:posizione
                    },
                    success:function(esito) {
                        if(esito=="ok") {                
                            aggiornaComponentiPagina();
                        }
                        else if(esito=="ok,ricarica") {
                            aggiornaComponentiPagina();
                            location.reload();
                        }
                        else {
                            alert(esito);
                        }
                    },
                    error: function(xhr,status,error) {
                        alert(status+" "+error);
                    }
                });
            }

            function duplicaComponente(idComponente) {
                $.ajax({
                    type:"POST",
                    url:"../../../controller/controllerContenuti.php",
                    data:{
                        operazione:"duplicaComponente",
                        id:<?php echo $contenuto->getId() ?>,
                        idComponente:idComponente
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            aggiornaComponentiPagina();
                        }
                        else if(esito=="ok,ricarica") {
                            aggiornaComponentiPagina();
                            location.reload();
                        }
                        else {
                            alert(esito);
                        }
                    },
                    error: function(xhr,status,error) {
                        alert(status+" "+error);
                    }
                });
            }

            function aggiornaComponentiPagina() {
                $.ajax({
                    type:"POST",
                    url:"../../../controller/controllerContenuti.php",
                    data:{
                        operazione:"stampaComponentiContenuto",
                        id:<?php echo $contenuto->getId() ?>
                    },
                    success:function(codice) {
                        document.getElementById("componentiContenuto").innerHTML = codice;
                    },
                    error: function(xhr,status,error) {
                        alert(status+" "+error);
                    }
                });
            }

            function eliminaComponentePagina(id,immagineComponente,nomeComponente,nomeElemento) {
                $('#componenteDaEliminare').val(id);
                document.getElementById("immagineComponenteDaEliminare").src = "../../"+immagineComponente;
                $('#nomeComponenteDaEliminare').text(nomeComponente);
                document.getElementById("nomeElementoDaEliminare").innerHTML = nomeElemento;
                $('#modalEliminaComponente').modal('show');
            }

            function eseguiEliminazioneComponentePagina() {
                var id = $('#componenteDaEliminare').val();
                $.ajax({
                    type:"GET",
                    url:"../../../controller/controllerContenuti.php",
                    data:{
                        operazione:"eliminaComponente",
                        id:id
                    },
                    success:function(result) {
                        if(result=="ok") {
                            document.getElementById("componentePagina"+id).className = "d-none";
                            $('#modalEliminaComponente').modal('hide');
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }

            function cambiaIdElemento(idComponente) {
                var idElemento = $("#idElementoComponente"+idComponente).val();
                
                $.ajax({
                    type:"GET",
                    url:"../../../controller/controllerContenuti.php",
                    data:{
                        operazione:"cambiaIdElemento",
                        id:idComponente,
                        idElemento:idElemento
                    },
                    success:function(result) {
                        if(result=="ok") {
                            $('#labelOperazioneCompletata').text("Componente aggiornato con successo");
                            $('#modalOperazioneCompletata').modal('show');
                            aggiornaComponentiPagina();
                        }
                        else {
                            alert(result);
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }

            function eliminaImmagineInEvidenza() {
                $.ajax({
                    type:"GET",
                    url:"../../../controller/controllerContenuti.php",
                    data:{
                        operazione:"eliminaImmagineInEvidenza",
                        id:<?php echo $contenuto->getId() ?>
                    },
                    success:function(result) {
                        if(result=="ok") {
                            document.getElementById("immagineInEvidenza").src="../../../immagini/altro/segnaposto.png";
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }

            function traduci(id) {
                var l =$('#linguaTraduzione').val();
                location.href="../controller/controllerContenuti.php?id="+id+"&operazione=traduci&lingua="+l;
            }

            function eliminaPagina(id,titoloPagina) {
                $('#paginaDaEliminare').val(id);
                $('#nomePaginaDaEliminare').text(titoloPagina);
                $('#modalEliminaTraduzione').modal('show');
            }

            function eseguiEliminazionePagina() {
                var id = $('#paginaDaEliminare').val();
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerContenuti.php",
                    data:{
                        operazione:"elimina",
                        id:id
                    },
                    success:function(result) {
                        if(result=="ok") {
                            document.getElementById("pagina"+id).className = "d-none";
                            $('#modalEliminaTraduzione').modal('hide');
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function spostaElemento(idElemento) {
                var portfolioDestinazione = document.getElementById("portfolioDestinazione").value;
                location.href = "controller/controllerElementi.php?operazione=spostaElemento&id="+idElemento+"&idPortfolio="+portfolioDestinazione;
            }
            
            function duplicaElemento(idElemento) {
                var portfolioDestinazione = document.getElementById("portfolioDestinazione").value;
                location.href = "controller/controllerElementi.php?operazione=duplicaInAltroPortfolio&id="+idElemento+"&idPortfolio="+portfolioDestinazione;
            }
            
            function gestoreLinkPersonalizzato() {
                if(document.getElementById("linkPersonalizzato").checked) {
                    document.getElementById("divAliasContenuto").className = "form-group col-12";
                    document.getElementById("divUrlContenuto").className = "d-none";
                    document.getElementById("labelAlias").innerHTML      = "URL";
                }
                else {
                    document.getElementById("divAliasContenuto").className = "form-group col-md-5";
                    document.getElementById("divUrlContenuto").className = "form-group col-md-7";
                    document.getElementById("labelAlias").innerHTML      = "Alias";
                    
                    var alias = document.getElementById("valoreAlias").value
                    var sottoStringaAlias = alias.substring(0,4);
                    if(sottoStringaAlias=="http" || sottoStringaAlias=="www.") {
                        document.getElementById("valoreAlias").value = "";
                    }
                }
            }
           
        </script>
    </body>
</html>